
<?php
// Configuración
$destinatario = 'jose@lienzo.co';
$asunto = 'Nuevo mensaje de contacto - Constructora ECO';

// Verificar si el formulario fue enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Obtener y limpiar los datos del formulario
    $nombre = trim($_POST['nombre'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $telefono = trim($_POST['telefono'] ?? '');
    $mensaje = trim($_POST['mensaje'] ?? '');
    
    // Validar campos obligatorios
    if (empty($nombre) || empty($email) || empty($mensaje)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Por favor complete todos los campos obligatorios.']);
        exit;
    }
    
    // Validar formato de email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Por favor ingrese un email válido.']);
        exit;
    }
    
    // Construir el mensaje
    $mensaje_completo = "
    Nuevo mensaje de contacto desde el sitio web de Constructora ECO
    
    Nombre: $nombre
    Email: $email
    Teléfono: $telefono
    
    Mensaje:
    $mensaje
    
    ---
    Este mensaje fue enviado desde el formulario de contacto del sitio web.
    Fecha: " . date('d/m/Y H:i:s');
    
    // Configurar headers para el email
    $headers = array(
        'From: noreply@constructoraeco.com.py',
        'Reply-To: ' . $email,
        'X-Mailer: PHP/' . phpversion(),
        'Content-Type: text/plain; charset=UTF-8'
    );
    
    // Enviar el email
    if (mail($destinatario, $asunto, $mensaje_completo, implode("\r\n", $headers))) {
        echo json_encode(['success' => true, 'message' => 'Mensaje enviado correctamente. Nos pondremos en contacto contigo pronto.']);
    } else {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error al enviar el mensaje. Por favor intente nuevamente.']);
    }
} else {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
}
?>